<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductSize extends Model 
{

    protected $table = 'product_size';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function ingredient()
    {
        return $this->hasMany('ProductSizeIngredient');
    }

    public function product()
    {
        return $this->belongsTo('Product');
    }

    public function size()
    {
        return $this->belongsTo('Size');
    }

}